﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;

namespace Framework.Web
{
    public static class Lang
    {
        private const string CLASS_NAME = "Framework.Web.Lang";

        public static string Current
        {
            get
            {
                return Lang.CurrentCulture.Name;
            }
            set
            {
                Lang.CurrentCulture = new CultureInfo(value, true);
            }
        }

        public static CultureInfo CurrentCulture
        {
            get 
            {
                return SessionMgr.Load<CultureInfo>(CLASS_NAME, "Current", true, () => System.Threading.Thread.CurrentThread.CurrentUICulture);
            }
            set
            {
                SessionMgr.Save(CLASS_NAME, "Current", value, true);
            }
        }
    }
}
